<?php
/* --------------------------------------------------------------
   AbstractImageConfiguration.php 2023-01-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2023 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\ImageProcessing\Model\Configuration;

/**
 * Class AbstractImageConfiguration
 *
 * @package Gambio\Admin\Modules\ImageProcessing\Model\Configuration
 */
abstract class AbstractImageConfiguration implements ImageConfiguration
{
    /**
     * GalleryImageConfiguration constructor.
     *
     * @param int    $height
     * @param int    $width
     * @param string $path
     */
    public function __construct(private int $height, private int $width, private string $path)
    {
    }
    
    
    /**
     * @inheritDoc
     */
    public function height(): int
    {
        return $this->height;
    }
    
    
    /**
     * @inheritDoc
     */
    public function width(): int
    {
        return $this->width;
    }
    
    
    /**
     * @inheritDoc
     */
    public function path(): string
    {
        return $this->path;
    }
}